/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
  i-net software 1998-2013

*/
namespace Inet.Viewer.Data
{

    /// <summary>
    /// Takes the information coming from the server after a ping and interprets the answer.
    /// If the ping was not successful, the ping loader throws a ViewerException to tell the
    /// ping's timer to repaint and ping no more.
    /// </summary>
    public class PingLoader : Loader
    {
        /// <summary>
        /// Provide the state of the report on the server.
        /// </summary>
        public ReportState RenderState { get; private set; }
        /// <summary>
        /// <inheritdoc/>
        /// </summary>
        /// <param name="token"></param>
        /// <returns></returns>
        protected internal override bool Load(int token)
        {
            if (token == ViewerTokenConstants.TokenPingInfo)
            {
                bool wasSuccessful = ReadBoolean();
                // progress is only transmitted by listeners of versions >=13.1
                if (TokenSize > 1)
                {
                    int progress = ReadInt();
                    string state = ReadString();
                    RenderState = new ReportState(state, progress);
                }
                return true;
            }
            return base.Load(token);
        }
    }
}